function settings=load_settings(config_fname)
% does config_fname exist? If not, load the one in the matlab paths
if ~isfile(config_fname)
    if exist(config_fname,'file')

        fprintf('No custom setting file provided. Using default %s for processing.\n', config_fname);
        config_fname=which(config_fname);

    else
        error([config_fname,' does not exist.']);
    end
else
    fprintf('%s is provided in the current folder, overriding default %s.\n',config_fname,config_fname);
end
   


if isfile('processing_settings.mat')
    warning('processing_settings.mat exists. Overwrite existing setting records?(Y/N)');
    x=input('','s');
    if x=='Y'||x=='y'
        % save inputs for record keeping and for a01
        fprintf('Overwrite setting records and continue with processing.\n');
        txt=fileread(config_fname);
        settings=jsondecode(txt);
        save('processing_settings.mat','settings');
    elseif x=='N'||x=='n'
        fprintf('Loading existing setting records and reprocess using the same settings.\n');
        S=load('processing_settings.mat');
        settings=S.settings;
    end
else
    %load and save settings
    txt=fileread(config_fname);
    settings=jsondecode(txt);
    save('processing_settings.mat','settings');
end


% NEED TO WORK ON THIS
% %% Verify inputs
% % try
%     assert(isnumeric(input.batch_num),'Error. batch_num is not a number.\n')
%     assert(isnumeric(input.startingsliceidx),'Error. startingsliceidx is not a number.\n')
%     assert(input.use_predefined_thresh==0||input.use_predefined_thresh==1,'Error. use_predefined_thresh should be 0 or 1.\n')
%     assert(isKey(scope_settings,lower(input.scope_name)),'Error. scope_name is not in the list of scopes.\n')
%     assert(ischar(input.codebook_name),'Error. codebook_name is not valid.\n')
%     assert(ischar(input.codebookhyb_name),'Error. codebookhyb_name is not valid.\n')
%     assert(input.is_barcoded==0||input.is_barcoded==1,'Error. is_barcoded should be 0 or 1.\n')
%     assert(isnumeric(input.count_thresh),'Error. count_thresh is not a number.\n')
%     assert(isnumeric(input.err_corr_thresh),'Error. err_corr_thresh is not a number.\n')
%     assert(size(input.hybthresh,2)==4,'Error. hybthresh should be an n x 4 matrix.\n')
%     assert(size(input.hybbgn,2)==4,'Error. hybbgn should be an n x 4 matrix.\n')
%     assert(size(input.rolthresh,2)==4,'Error. rolthresh should be an n x 4 matrix.\n')
% catch
%     error('Error. Missing inputs, aborting.\n')
% end


%

end

    


